/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmitySearchCommunitiesPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFeedDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006JI\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0019J;\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J>\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010$\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tJ\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010+\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\tJI\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006/"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityLocalDataStore;", "", "()V", "deleteCommunity", "Lio/reactivex/rxjava3/core/Completable;", "communityId", "", "getCommunities", "Lio/reactivex/rxjava3/core/Flowable;", "", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "ids", "getCommunityById", "getCommunityPagingSource", "Landroidx/paging/PagingSource;", "", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;", "isDeleted", "", "includeDiscoverablePrivateCommunity", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;Ljava/lang/Boolean;Z)Landroidx/paging/PagingSource;", "getLatestCommunity", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getPostCount", "targetId", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "getSearchCommunitiesPagingSource", "query", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityMembershipStatusFilter;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "categoryIds", "hasInLocal", "observeCommunity", "saveCommunities", "communities", "searchCommunityPagingSource", "updateJoinCommunity", "amity-sdk_release"})
public final class CommunityLocalDataStore {
    @Nullable
    public final CommunityEntity getCommunityById(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Ref.ObjectRef community = new Ref.ObjectRef();
        Completable.fromCallable(() -> CommunityLocalDataStore.getCommunityById$lambda$0(communityId, community)).subscribeOn(Schedulers.io()).blockingAwait();
        return (CommunityEntity)community.element;
    }

    @NotNull
    public final Flowable<List<CommunityEntity>> getCommunities(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Flowable flowable = UserDatabase.get().communityDao().observeByCommunityIds(ids).map(new Function(ids){
            final /* synthetic */ List<String> $ids;
            {
                this.$ids = $ids;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<CommunityEntity> apply(@NotNull List<CommunityEntity> entities) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter(entities, (String)"entities");
                Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)this.$ids);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    IndexedValue it = (IndexedValue)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map orderById = destination$iv$iv;
                Iterable $this$sortedBy$iv = entities;
                boolean $i$f$sortedBy = false;
                List sortedCommunities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
                    final /* synthetic */ Map $orderById$inlined;
                    {
                        this.$orderById$inlined = map;
                    }

                    public final int compare(T a, T b) {
                        CommunityEntity it = (CommunityEntity)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)this.$orderById$inlined.get(it.getCommunityId());
                        it = (CommunityEntity)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getCommunityId())));
                    }
                });
                return sortedCommunities;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ids: List<String>): Flow\u2026Communities\n            }");
        return flowable;
    }

    @NotNull
    public final Flowable<CommunityEntity> observeCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Flowable<CommunityEntity> flowable = UserDatabase.get().communityDao().getByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().communityDao().getByCommunityId(communityId)");
        return flowable;
    }

    @NotNull
    public final Completable saveCommunities(@NotNull List<? extends CommunityEntity> communities) {
        Intrinsics.checkNotNullParameter(communities, (String)"communities");
        Completable completable = Completable.fromAction(() -> CommunityLocalDataStore.saveCommunities$lambda$1(communities));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026Dao().save(communities) }");
        return completable;
    }

    @NotNull
    public final Completable updateJoinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = Completable.fromAction(() -> CommunityLocalDataStore.updateJoinCommunity$lambda$2(communityId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026munityId, true)\n        }");
        return completable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = UserDatabase.get().communityDao().deleteByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"get().communityDao().del\u2026yCommunityId(communityId)");
        return completable;
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        EkoFeedDao feedDao = UserDatabase.get().feedDao();
        getPostCount.1 var4_4 = getPostCount.1.INSTANCE;
        Flowable flowable = feedDao.getCommunityFeed(targetId, feedType.getApiKey()).map(new Function((Function1)var4_4){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object t) {
                return this.function.invoke(t);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"feedDao.getCommunityFeed\u2026ap(FeedEntity::postCount)");
        return flowable;
    }

    public final boolean hasInLocal(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        return communityDao.getByIdNow(communityId) != null;
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> getCommunityPagingSource(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortOption, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().communityQueryPagingDao().getCommunityPagingSource(keyword, categoryId, filter, sortOption, isDeleted, includeDiscoverablePrivateCommunity);
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> searchCommunityPagingSource(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortOption, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().communitySearchPagingDao().getCommunityPagingSource(keyword, categoryId, filter, sortOption, isDeleted, includeDiscoverablePrivateCommunity);
    }

    @NotNull
    public final Flowable<CommunityEntity> getLatestCommunity(@NotNull String categoryId, @NotNull AmityCommunityFilter filter, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable<CommunityEntity> flowable = UserDatabase.get().communityDao().getLatestCommunity(categoryId, filter, isDeleted, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().communityDao().get\u2026 DateTime.now()\n        )");
        return flowable;
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> getSearchCommunitiesPagingSource(@NotNull String query, @Nullable AmityCommunityMembershipStatusFilter filter, @Nullable AmityTags tags, @Nullable List<String> categoryIds) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        AmitySearchCommunitiesPagingDao amitySearchCommunitiesPagingDao = UserDatabase.get().searchCommunitiesPagingDao();
        Intrinsics.checkNotNullExpressionValue((Object)amitySearchCommunitiesPagingDao, (String)"get().searchCommunitiesPagingDao()");
        return AmitySearchCommunitiesPagingDao.DefaultImpls.getSearchCommunitiesPagingSource$default(amitySearchCommunitiesPagingDao, query, filter, tags, categoryIds, null, 16, null);
    }

    private static final Unit getCommunityById$lambda$0(String $communityId, Ref.ObjectRef $community) {
        Intrinsics.checkNotNullParameter((Object)$communityId, (String)"$communityId");
        Intrinsics.checkNotNullParameter((Object)$community, (String)"$community");
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        CommunityEntity entity = communityDao.getByIdNow($communityId);
        if (entity != null) {
            $community.element = entity;
        }
        return Unit.INSTANCE;
    }

    private static final void saveCommunities$lambda$1(List $communities) {
        Intrinsics.checkNotNullParameter((Object)$communities, (String)"$communities");
        UserDatabase.get().communityDao().save($communities);
    }

    private static final void updateJoinCommunity$lambda$2(String $communityId) {
        Intrinsics.checkNotNullParameter((Object)$communityId, (String)"$communityId");
        UserDatabase.get().communityDao().updateIsJoinedByCommunityId($communityId, true);
    }
}

