package com.ekoapp.ekosdk.internal.api.hash;

public class EkoBloomFilter {

    private static final int SEED = 1576284489;

    private final byte[] buckets;
    private final int m;
    private final int k;


    private EkoBloomFilter(byte[] buckets, int m, int k) {
        this.buckets = buckets;
        this.m = m;
        this.k = k;
    }

    public boolean mightContains(String element) {
        int[] locations = locationFor(element.getBytes());

        for (int i = 0; i < k; i++) {
            int location = locations[i];
            int index = (int) Math.floor(location / 8);
            if ((buckets[index] & 1 << (location % 8)) == 0) {
                return false;
            }
        }

        return true;
    }

    private int[] locationFor(byte[] buf) {
        int hash1 = new EkoFnv1a().hash(buf, 0);
        int hash2 = new EkoFnv1a().hash(buf, SEED);

        int[] locations = new int[k];
        int location = hash1 % m;

        for (int i = 0; i < k; i++) {
            locations[i] = location < 0 ? (location + m) : location;
            location = (location + hash2) % m;
        }

        return locations;
    }

    public static class Builder {

        private final byte[] buckets;
        private final int m;
        private final int k;


        public Builder(byte[] buckets, int m, int k) {
            this.buckets = buckets;
            this.m = m;
            this.k = k;
        }

        public EkoBloomFilter build() {
            return new EkoBloomFilter(buckets, m, k);
        }
    }
}
