package com.amity.socialcloud.sdk.core.data.pin

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.core.pin.AmityPinTarget
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.ekoapp.ekosdk.internal.data.model.PinEntity

class PinnedPostModelMapper : ModelMapper<PinEntity, AmityPinnedPost>() {
    override fun map(entity: PinEntity): AmityPinnedPost {
        return entity.run {
            AmityPinnedPost(
                pinId = pinId,
                postId = referenceId,
                placement = placement,
                target = AmityPinTarget(
                    targetId = targetId,
                    targetType = targetType,
                    lastPinsUpdatedAt = lastPinsUpdatedAt,
                ),
                pinnedById = pinnedBy,
                pinnedAt = pinnedAt,
            )
        }
    }
}