package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsEntity
import io.reactivex.rxjava3.core.Flowable


@Dao
abstract class UserSettingsDao : EkoObjectDao<UserSettingsEntity>() {

    @Query("select * from user_settings where settingId = :settingId")
    abstract fun getUserSettings(settingId: String): Flowable<UserSettingsEntity>

    @Query("DELETE from user_settings")
    abstract override fun deleteAll()
}