package com.ekoapp.ekosdk.internal.data.model;

import static com.ekoapp.ekosdk.internal.util.EkoPreconditions.checkValidId;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

@Entity(tableName = "api_key")
public class EkoApiKey {

    private static final String SINGLETON_API_KEY_ID = "SINGLETON_API_KEY_ID";

    @PrimaryKey
    @NonNull
    private String id = currentApiKeyId();
    private String apiKey;
    private long updateAt = System.currentTimeMillis();


    public static String currentApiKeyId() {
        return SINGLETON_API_KEY_ID;
    }

    @NonNull
    public String getId() {
        return currentApiKeyId();
    }

    public void setId(String id) {
        // NO OP
        this.id = currentApiKeyId();
    }

    @NonNull
    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(@NonNull String apiKey) {
        this.apiKey = checkValidId(apiKey, "apiKey");
    }

    public long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoApiKey create(@NonNull String apiKey) {
        EkoApiKey ekoApiKey = new EkoApiKey();
        ekoApiKey.setApiKey(apiKey);
        return ekoApiKey;
    }
}
