package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.dto.community.JoinRequestActionDto
import com.amity.socialcloud.sdk.dto.community.JoinRequestQueryDto
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.PUT
import retrofit2.http.Path
import retrofit2.http.Query

interface CommunityApi {

    @GET("api/v3/communities/{communityId}")
    fun getCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @GET("api/v3/communities/recommended")
    fun getRecommendedCommunities(
        @Query("includeDiscoverablePrivateCommunity") includeDiscoverablePrivateCommunity: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null,
    ): Single<CommunityListQueryDto>

    @GET("api/v3/communities/top-trending")
    fun getTrendingCommunities(
        @Query("includeDiscoverablePrivateCommunity") includeDiscoverablePrivateCommunity: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null,
    ): Single<CommunityListQueryDto>

    @GET("api/v3/communities")
    fun queryCommunities(
        @Query("keyword") keyword: String? = null,
        @Query("includeDiscoverablePrivateCommunity") includeDiscoverablePrivateCommunity: Boolean? = null,
        @Query("categoryId") categoryId: String? = null,
        @Query("filter") filter: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null,
    ): Single<CommunityListQueryDto>

    @POST("api/v3/communities")
    fun createCommunity(@Body request: CommunityCreateRequest): Single<CommunityListQueryDto>

    @PUT("api/v3/communities/{communityId}")
    fun updateCommunity(
        @Path("communityId") communityId: String,
        @Body request: CommunityUpdateRequest,
    ): Single<CommunityListQueryDto>

    @DELETE("api/v3/communities/{communityId}")
    fun deleteCommunity(@Path("communityId") communityId: String): Single<EkoDeletionDto>

    @POST("api/v3/communities/{communityId}/join")
    fun joinCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @POST("api/v4/communities/{communityId}/join")
    fun joinRequest(@Path("communityId") communityId: String): Single<JoinRequestQueryDto>

    @POST("api/v4/communities/{communityId}/join/approve")
    fun approveJoinRequest(
        @Path("communityId") communityId: String,
        @Query("userId") userId: String,
    ): Single<JoinRequestActionDto>

    @POST("api/v4/communities/{communityId}/join/reject")
    fun rejectJoinRequest(
        @Path("communityId") communityId: String,
        @Query("userId") userId: String,
    ): Single<JoinRequestActionDto>


    @DELETE("api/v4/communities/{communityId}/join")
    fun cancelJoinRequest(@Path("communityId") communityId: String): Single<JoinRequestActionDto>

    @GET("api/v4/communities/{communityId}/join")
    fun getJoinRequest(
        @Path("communityId") communityId: String,
        @Query("status") status: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("targetType") targetType: String? = null,
        @Query("type") type: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null,
    ): Single<JoinRequestQueryDto>

    @GET("api/v4/communities/join/requests")
    fun getLatestJoinRequest(
        @Query("communityIds[]", encoded = true) communityIds: List<String>,
    ): Single<JoinRequestQueryDto>

    @GET("api/v4/communities/{communityId}/join/me")
    fun getMyJoinRequest(@Path("communityId") communityId: String): Single<JoinRequestQueryDto>

    @DELETE("api/v3/communities/{communityId}/leave")
    fun leaveCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @GET("api/v1/semantic-search/communities")
    fun searchCommunities(
        @Query("query") query: String,
        @Query("filter") filter: String? = null,
        @Query("categoryIds[]", encoded = true) categoryIds: List<String>?,
        @Query("includeDiscoverablePrivateCommunity") includeDiscoverablePrivateCommunity: Boolean? = null,
        @Query("tags[]", encoded = true) tags: List<String>?,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null,
    ): Single<CommunityListQueryDto>

    @GET("aapi/v3/communities/list")
    fun getCommunityByIds(
        @Query("communityIds[]") communityId: List<String>,
        @Query("includeDiscoverablePrivateCommunity") includeDiscoverablePrivateCommunity: Boolean? = null,
    ): Single<CommunityListQueryDto>
}