package com.amity.socialcloud.sdk.core.data.notificationtray

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingConfig
import androidx.paging.PagingData
import co.amity.rxbridge.toRx3
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.core.data.notificationtray.paging.NotificationTrayMediator
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@OptIn(ExperimentalPagingApi::class)
internal class NotificationTrayItemRepository {

    fun getNotificationTrayItemPagingData(): Flowable<PagingData<AmityNotificationTrayItem>> {
        val pagerCreator = QueryStreamPagerCreator(
            pagingConfig = PagingConfig(
                pageSize = AmityObjectRepository.DEFAULT_PAGE_SIZE,
                enablePlaceholders = false,
            ),
            queryStreamMediator = NotificationTrayMediator(),
            pagingSourceFactory = { NotificationTrayLocalDataStore().getNotificationTrayItemPagingSource() },
            modelMapper = NotificationTrayModelMapper()
        )
        return pagerCreator.create().toRx3()
    }

    fun markSeen(notiTrayItemId: String): Completable {
        return NotificationTrayRemoteDataStore().markTrayItemSeen(
            notiTrayItemId = notiTrayItemId
        )
            .flatMapCompletable {
                NotificationTrayLocalDataStore().markSeen(
                    notificationId = notiTrayItemId,
                    lastSeenAt = it.lastSeenAt ?: DateTime.now()
                )
            }.onErrorResumeNext {
                Completable.error(it)
            }
    }

}