package com.amity.socialcloud.sdk.social.data.community.paging

import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

class CommunityJoinRequestKeyCreator(
    private val communityId: String,
    private val status: String,
    private val sortBy: AmityCommunitySortOption? = null,
    private val targetType: String,
    private val type: String,
) : QueryStreamKeyCreator {
    override fun toMap(): Map<String, Any> {
        return mapOf(
            "communityId" to communityId,
            "status" to status,
            "sortBy" to (sortBy?.apiKey ?: ""),
            "targetType" to targetType,
            "type" to type
        )
    }

    override fun optionalFilterQuery(): String {
        return ""
    }
}