package com.amity.socialcloud.sdk.core.session

import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException

internal object SessionError {

    fun fromState(sessionState: SessionState): AmityException {
        return when (sessionState) {
            is SessionState.NotLoggedIn -> AmityException.create(
                "Please login to use SDK",
                null,
                AmityError.NOT_LOGGED_IN
            )
            is SessionState.Establishing -> AmityException.create(
                "Unable to use SDK while the SDK is logging in",
                null,
                AmityError.ESTABLISHING_ERROR
            )
            is SessionState.TokenExpired -> AmityException.create(
                "The access token is already expired, please give the new auth token or re-login the SDK",
                null,
                AmityError.TOKEN_EXPIRED
            )
            is SessionState.Terminated -> sessionState.amityException

            else -> AmityException.create(
                "Unknown error",
                null,
                AmityError.UNKNOWN
            )
        }
    }

}