package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.google.gson.reflect.TypeToken

class StringListConverter {
	@TypeConverter
	fun stringToStringList(json: String?): List<String> {
		return EkoGson.get().fromJson(json, object : TypeToken<List<String?>?>() {}.type)
	}
	
	@TypeConverter
	fun stringListToString(list: List<String?>?): String {
		return EkoGson.get().toJson(list)
	}
}