package com.amity.socialcloud.sdk.model.social.community

enum class AmityJoinRequestStatus {
    PENDING,
    APPROVED,
    REJECTED,
    CANCELLED;

    companion object {
        fun fromApiKey(apiKey: String): AmityJoinRequestStatus = when (apiKey.lowercase()) {
            "pending" -> PENDING
            "approved" -> APPROVED
            "rejected" -> REJECTED
            "cancelled" -> CANCELLED
            else -> throw IllegalArgumentException("Unknown status: $apiKey")
        }
    }
}