package com.amity.socialcloud.sdk.core.data.invitation

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationStatus
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity

class InvitationModelMapper : ModelMapper<InvitationEntity, AmityInvitation>() {
    override fun map(entity: InvitationEntity): AmityInvitation {
        return entity.run {
            AmityInvitation(
                invitationId = invitationId,
                targetType = targetType,
                targetId = targetId,
                userId = userId,
                createdAt = createdAt,
                updatedAt = updatedAt,
                type = AmityInvitationType.enumOf(type),
                status = AmityInvitationStatus.enumOf(status),
                createdById = createdById,
            )
        }
    }
}