package com.amity.socialcloud.sdk.chat.domain.marker.message

import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageDeliveredUsersRequest
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.ekoapp.ekosdk.internal.api.dto.MessageDeliveredUsersQueryDto
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class MessageDeliveredUsersComposerUseCase {
	
	fun execute(request: MessageDeliveredUsersRequest): Single<MessageDeliveredUsersQueryDto> {
		return MessageMarkerRepository().fetchMessageDeliveredUsers(request)
			.flatMap { dto ->
				UserRepository().getUserDtoByIds(dto.userIds)
					.map { usersDto ->
						dto.apply {
							users = usersDto
						}
					}
			}.subscribeOn(Schedulers.io())
	}
}