package com.amity.socialcloud.sdk.chat.domain.channel

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetChannelPagingDataUseCase {

    fun execute(
        isDeleted: Boolean?,
        types: Set<AmityChannel.Type>,
        filter: AmityChannelFilter,
        includingTags: AmityTags,
        excludingTags: AmityTags,
    ): Flowable<PagingData<AmityChannel>> {
        return ChannelRepository().getChannelPagingData(
            types,
            filter,
            includingTags,
            excludingTags,
            isDeleted
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { channel ->
                ChannelComposerUseCase().execute(channel)
            }
        }
    }

}