package com.amity.socialcloud.sdk.api.social.comment.latest

import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.ekoapp.ekosdk.internal.usecase.comment.LatestCommentQueryUseCase
import io.reactivex.rxjava3.core.Single

class AmityLatestCommentQuery internal constructor(
    private val referenceId: String,
    private val referenceType: String,
    private val isFilterByParentId: Boolean
) {

    /**
     * observe latest comments
     * @return LiveObject of latest comment as Single<AmityComment>
     */
    fun query(): Single<AmityComment> {
        return LatestCommentQueryUseCase().execute(referenceId, referenceType, isFilterByParentId)
    }

    class Builder internal constructor(){
        private lateinit var referenceId: String
        private lateinit var referenceType: String
        private var isFilterByParentId: Boolean = false

        internal fun referenceType(referenceType: String): Builder {
            return apply { this.referenceType = referenceType }
        }

        internal fun referenceId(referenceId: String): Builder {
            return apply { this.referenceId = referenceId }
        }

        /**
         * @param [includeReplies]
         * When [includeReplies] is true, the result returns latest all-levels comment created on the reference
         * When [includeReplies] is false, the result returns latest root-level comment created on the reference
         * @return the same AmityLatestCommentQuery.Builder instance.
         */
        fun includeReplies(includeReplies: Boolean): Builder {
            this.isFilterByParentId = !includeReplies
            return this
        }

        /**
         * Instantiates AmityLatestCommentQuery with built params.
         * @return new instance of AmityLatestCommentQuery.
         */
        fun build(): AmityLatestCommentQuery {
            return AmityLatestCommentQuery(
                referenceId = referenceId,
                referenceType = referenceType,
                isFilterByParentId = isFilterByParentId
            )
        }
    }

}