/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.InvitationDao;
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public final class InvitationDao_Impl
extends InvitationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<InvitationEntity> __insertionAdapterOfInvitationEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<InvitationEntity> __deletionAdapterOfInvitationEntity;
    private final EntityDeletionOrUpdateAdapter<InvitationEntity> __updateAdapterOfInvitationEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

    public InvitationDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfInvitationEntity = new EntityInsertionAdapter<InvitationEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `invitation` (`invitationId`,`type`,`targetId`,`targetType`,`invitedUserId`,`inviterUserId`,`status`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, InvitationEntity value) {
                if (value.getInvitationId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getInvitationId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetType());
                }
                if (value.getInvitedUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getInvitedUserId());
                }
                if (value.getInviterUserId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getInviterUserId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getStatus());
                }
                String _tmp = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfInvitationEntity = new EntityDeletionOrUpdateAdapter<InvitationEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `invitation` WHERE `invitationId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, InvitationEntity value) {
                if (value.getInvitationId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getInvitationId());
                }
            }
        };
        this.__updateAdapterOfInvitationEntity = new EntityDeletionOrUpdateAdapter<InvitationEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `invitation` SET `invitationId` = ?,`type` = ?,`targetId` = ?,`targetType` = ?,`invitedUserId` = ?,`inviterUserId` = ?,`status` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `invitationId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, InvitationEntity value) {
                if (value.getInvitationId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getInvitationId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetType());
                }
                if (value.getInvitedUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getInvitedUserId());
                }
                if (value.getInviterUserId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getInviterUserId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getStatus());
                }
                String _tmp = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                if (value.getInvitationId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getInvitationId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from invitation";
                return "DELETE from invitation";
            }
        };
        this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE invitation SET status = ? WHERE invitationId = ?";
                return "UPDATE invitation SET status = ? WHERE invitationId = ?";
            }
        };
    }

    @Override
    public void insertImpl(InvitationEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfInvitationEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends InvitationEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfInvitationEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends InvitationEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfInvitationEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(InvitationEntity invitation) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfInvitationEntity.handle((Object)invitation);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(InvitationEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfInvitationEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(InvitationEntity object) {
        this.__db.beginTransaction();
        try {
            InvitationDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends InvitationEntity> objects) {
        this.__db.beginTransaction();
        try {
            InvitationDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(InvitationEntity object) {
        this.__db.beginTransaction();
        try {
            InvitationDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateStatus(String invitationId, String status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateStatus.acquire();
        int _argIndex = 1;
        if (status == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, status);
        }
        _argIndex = 2;
        if (invitationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, invitationId);
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvitationEntity getInvitation(String targetId) {
        String _sql = "SELECT * FROM invitation WHERE targetId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM invitation WHERE targetId = ?", (int)1);
        int _argIndex = 1;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            InvitationEntity _result;
            int _cursorIndexOfInvitationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invitationId");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfInvitedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invitedUserId");
            int _cursorIndexOfInviterUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviterUserId");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpInvitationId = _cursor.isNull(_cursorIndexOfInvitationId) ? null : _cursor.getString(_cursorIndexOfInvitationId);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpInvitedUserId = _cursor.isNull(_cursorIndexOfInvitedUserId) ? null : _cursor.getString(_cursorIndexOfInvitedUserId);
                String _tmpInviterUserId = _cursor.isNull(_cursorIndexOfInviterUserId) ? null : _cursor.getString(_cursorIndexOfInviterUserId);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                _result = new InvitationEntity(_tmpInvitationId, _tmpType, _tmpTargetId, _tmpTargetType, _tmpInvitedUserId, _tmpInviterUserId, _tmpStatus);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            InvitationEntity invitationEntity = _result;
            return invitationEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

