package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto

internal class ChannelMemberRemoved : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.membersRemoved"
    }
    
    override fun processEvent(dto: ChannelEventDto) {
        super.processEvent(dto)
        if (isActiveUserRemovedEvent(dto)) {
            MarkerEventBus.publish(MarkerEvent.ChannelLeft(getEventName(), dto))
            MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
        }
    }

}