package com.amity.socialcloud.sdk.dto.video

import com.ekoapp.ekosdk.internal.api.dto.EkoObjectDto
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName

data class EkoStreamDto constructor(
	@SerializedName("streamId")
	val streamId: String,

	@SerializedName("moderationId")
	val moderationId: String? = null,

	@SerializedName("title")
	val title: String? = null,

	@SerializedName("description")
	val description: String? = null,

	@SerializedName("metadata")
	val metadata: JsonObject? = null,

	@SerializedName("isReconnecting")
	val isReconnecting: Boolean = false,

	@SerializedName("thumbnailFileId")
	val thumbnailFileId: String? = null,

	@SerializedName("userId")
	val userId: String? = null,

	@SerializedName("status")
	val status: String? = null,

	@SerializedName("watcherUrl")
	val watcherData: JsonObject? = null,

	@SerializedName("streamerUrl")
	val broadcasterData: JsonObject? = null,

	@SerializedName("recordings")
	val recordings: JsonArray? = null,

	@SerializedName("resolution")
	val resolution: String? = null,

	@SerializedName("isDeleted")
	val isDeleted: Boolean = false,

	@SerializedName("referenceId")
	val referenceId: String? = null,

	@SerializedName("referenceType")
	val referenceType: String? = null,

	@SerializedName("targetId")
	val targetId: String? = null,

	@SerializedName("targetType")
	val targetType: String? = null,
) : EkoObjectDto()