package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionAddedDto
import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionRemovedDto
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.AddReactionRequest
import com.ekoapp.ekosdk.internal.api.socket.request.RemoveReactionRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface ReactionApi {

    @GET("api/v3/reactions")
    fun queryReactions(
        @Query("referenceType") referenceType: String,
        @Query("referenceId") referenceId: String,
        @Query("reactionName") reactionName: String? = null,
        @Query("referenceVersion") referenceVersion: Int? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<EkoReactionAndUserListDto>

    @POST("api/v2/reactions")
    fun addReaction(
        @Body request: AddReactionRequest
    ): Single<ReactionAddedDto>

    @HTTP(method = "DELETE", path = "api/v2/reactions", hasBody = true)
    fun removeReaction(
        @Body request: RemoveReactionRequest,
    ): Single<ReactionRemovedDto>

}