package com.amity.socialcloud.sdk.core.data.invitation

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import io.reactivex.rxjava3.core.Completable

internal class InvitationQueryPersister() : QueryPersister<InvitationsQueryDto>() {

    override fun persist(dto: InvitationsQueryDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(InvitationLocalDataStore().saveInvitations(InvitationEntityMapper().map(dto)))
    }
}