package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType

internal class InvitationKeyCreator(
    val type: AmityInvitationType,
    val target: InvitationMediator.Target,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return  mapOf(
            "type" to type.value,
            "targetId" to target.id,
            "targetType" to target.type,
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        val typeFilterStatement = "invitation.type = '${type.value}'"
        val targetFilterStatement = if (target is InvitationMediator.Target.ME) {
            " and invitation.invitedUserId = '${AmityCoreClient.getUserId()}'"
        } else {
            " and invitation.targetType = '${target.type}' and invitation.targetId = '${target.id}'"
        }
        return typeFilterStatement + targetFilterStatement
    }
}