package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects

@Entity(tableName = "invitation", primaryKeys = ["invitationId"])
data class InvitationEntity(
		val invitationId: String,
		val type: String,
		val targetId: String,
		val targetType: String,
		val invitedUserId: String,
		val inviterUserId: String,
		val status: String,
) : EkoObject() {
	override fun getId(): String {
		return invitationId
	}

	override fun equals(other: Any?): Boolean {
		if (other == null) return false
		if (other === this) return true
		return (other is InvitationEntity
				&& Objects.equal(invitationId, other.invitationId)
				&& Objects.equal(type, other.type)
				&& Objects.equal(targetId, other.targetId)
				&& Objects.equal(targetType, other.targetType)
				&& Objects.equal(invitedUserId, other.invitedUserId)
				&& Objects.equal(inviterUserId, other.inviterUserId)
				&& Objects.equal(status, other.status)
				&& Objects.equal(createdAt, other.createdAt)
				&& Objects.equal(updatedAt, other.updatedAt)
				)
	}

	override fun hashCode(): Int {
		return Objects.hashCode(
				invitationId,
				type,
				targetId,
				targetType,
				invitedUserId,
				inviterUserId,
				status,
				createdAt,
				updatedAt
		)
	}
}