package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import org.joda.time.DateTime

internal class NotificationTrayModelMapper :
    ModelMapper<NotificationTrayItemEntity, AmityNotificationTrayItem>() {
    override fun map(entity: NotificationTrayItemEntity): AmityNotificationTrayItem {
        return entity.run {
            AmityNotificationTrayItem(
                targetId = targetId,
                targetType = targetType,
                actionType = actionType ?: "",
                actionReferenceId = actionReferenceId ?: "",
                actors = actors,
                actorsCount = actorsCount ?: 0,
                id = notificationId,
                daySegment = daySegment,
                lastOccurredAt = lastOccurredAt,
                lastSeenAt = lastSeenAt,
                parentId = parentId ?: "",
                referenceId = referenceId ?: "",
                referenceType = referenceType ?: "",
                templatedText = templatedText ?: "",
                text = text ?: "",
                trayItemCategory = trayItemCategory ?: "",
                isSeen = entity.lastSeenAt?.isAfter(entity.lastOccurredAt) == true,
                isRecent = lastOccurredAt?.isAfter(DateTime.now().minusDays(7)) == true
            )
        }
    }
}