package com.amity.socialcloud.sdk.api.social.post.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityGlobalFeedQuery internal constructor(){

    /**
     * Queries for Global feed.
     * @return Flowable<PagingData<AmityPost>>.
     */
    fun query(): Flowable<PagingData<AmityPost>> {
        return GetGlobalFeedPagingDataUseCase().execute()
    }

    class Builder internal constructor(){

        /**
         * Instantiates AmityGlobalFeedQuery with built params.
         * @return new instance of AmityGlobalFeedQuery.
         */
        fun build(): AmityGlobalFeedQuery {
            return AmityGlobalFeedQuery()
        }
    }

}