package com.amity.socialcloud.sdk.api.social.post.create.datatype

import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.ekoapp.ekosdk.internal.usecase.post.CreatePostV4UseCase
import com.google.common.collect.FluentIterable
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

abstract class AmityPostCreator internal constructor(private val targetType: String,
                                                     private val targetId: String,
                                                     private val metadata: JsonObject? = null,
                                                     private val mentionees: List<AmityMentioneeTarget>? = null) {

    /**
     * Creates a post
     * @return Async post as Single<AmityPost>
     */
    fun post(): Single<AmityPost> {
        return CreatePostV4UseCase().execute(
            targetType = targetType,
            targetId = targetId,
            data = composeData(),
            dataType = if (isCustomDataType()) getPostDataType() else null,
            attachments = getAttachments(),
            metadata = metadata,
            mentionees = mentionees
        )
    }

    internal abstract fun getText(): String

    internal abstract fun getPostDataType(): AmityPost.DataType

    //only use this for 'liveStream' and 'poll' post for now, planned to support custom post creation in the future
    open fun isCustomDataType(): Boolean = false

    open fun getFiles(): List<AmityFileInfo>? {
        return null
    }

    open fun composeData(): JsonObject {
        val data = JsonObject()
        data.addProperty(TEXT_DATA_KEY, getText())
        return data
    }

    private fun getAttachments(): List<AmityPostAttachment>? {
        val isAttachmentValid =
            !getFiles().isNullOrEmpty() && AmityPost.DataType.isAttachmentType(getPostDataType().getApiKey())
        return if (isAttachmentValid) {
            FluentIterable.from(getFiles()!!)
                    .transform { file -> AmityPostAttachment(file!!.getFileId(), getPostDataType().getApiKey()) }
                    .toList()
        } else {
            null
        }
    }
}
internal const val TEXT_DATA_KEY = "text"