package com.amity.socialcloud.sdk.core.data.invitation

import com.amity.socialcloud.sdk.common.EntitySingleMapper
import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity

internal class InvitationEntityMapper :
    EntitySingleMapper<InvitationsQueryDto, InvitationEntity>() {

    override fun map(dto: InvitationsQueryDto): List<InvitationEntity> {
        val entities = mutableListOf<InvitationEntity>()
        dto.invitations.forEach { invitation ->
            val entity = InvitationEntity(
                invitationId = invitation.invitationId,
                type = invitation.type ?: "",
                targetId = invitation.targetId ?: "",
                targetType = invitation.targetType ?: "",
                invitedUserId = invitation.invitedUserId ?: "",
                inviterUserId = invitation.inviterUserId ?: "",
                status = invitation.status ?: "",
            )
            entities.add(entity)
        }
        return entities
    }
}