package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage.DataType.Companion.enumOf
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.TaggedEkoObject
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime
import kotlin.math.max

@Entity(
    tableName = "message",
    indices = [Index("subChannelId"),
        Index("syncState"),
        Index(value = ["subChannelId", "createdAt"]),
        Index(value = ["subChannelId", "channelSegment"])]
)
open class EkoMessageEntity : EkoObject(), TaggedEkoObject {

    @PrimaryKey
    var uniqueId: String = "LOCAL" + ObjectId.get().toHexString()

    var messageId: String = ObjectId.get().toHexString()
    var subChannelId: String = ""
    var channelId: String = ""
    var userId: String = ""
    var parentId: String? = null
    private var channelSegment: Int = 0
    var childrenNumber: Int = 0
    var editedAt: DateTime = DateTime.now()
    var isDeleted: Boolean = false
    var flagCount: Int = 0
    private var tags: AmityTags = AmityTags()
    var reactions: AmityReactionMap = AmityReactionMap()
    var reactionCount: Int = 0
    var type: String = AmityMessage.DataType.CUSTOM.apiKey
    var data: JsonObject? = null
    var metadata: JsonObject? = null
    var mentionees: List<EkoMentioneesDto> = emptyList()
    var path: String = ""
    
    // local properties
    var syncState: String = AmityMessage.State.SYNCED.stateName
    var messageMarkerHash: Int = 0

    override fun getId(): String {
        return uniqueId
    }

    override fun getTags(): AmityTags {
        return tags
    }

    fun setTags(tags: AmityTags) {
        this.tags = tags
    }

    fun getChannelSegment(): Int {
        return channelSegment
    }

    fun setChannelSegment(segment: Int) {
        this.channelSegment = max(this.channelSegment, segment)
    }

    fun getDataType(): AmityMessage.DataType {
        return enumOf(type)
    }

    fun setState(state: AmityMessage.State) {
        this.syncState = state.stateName
    }

    override fun equals(obj: Any?): Boolean {
        return (super.equals(obj)
                && Objects.equal(messageId, (obj as EkoMessageEntity).messageId)
                && Objects.equal(uniqueId, obj.messageId)
                && Objects.equal(subChannelId, obj.subChannelId)
                && Objects.equal(channelId, obj.channelId)
                && Objects.equal(userId, obj.userId)
                && Objects.equal(parentId, obj.parentId)
                && Objects.equal(channelSegment, obj.channelSegment)
                && Objects.equal(childrenNumber, obj.childrenNumber)
                && Objects.equal(editedAt, obj.editedAt)
                && Objects.equal(isDeleted, obj.isDeleted)
                && Objects.equal(flagCount, obj.flagCount)
                && Objects.equal(tags, obj.tags)
                && Objects.equal(reactions, obj.reactions)
                && Objects.equal(reactionCount, obj.reactionCount)
                && Objects.equal(type, obj.type)
                && Objects.equal(data, obj.data)
                && Objects.equal(syncState, obj.syncState)
                && Objects.equal(metadata, obj.metadata)
                && Objects.equal(mentionees, obj.mentionees))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            super.hashCode(),
            uniqueId,
            messageId,
            subChannelId,
            channelId,
            userId,
            parentId,
            channelSegment,
            childrenNumber,
            editedAt,
            isDeleted,
            flagCount,
            tags,
            reactions,
            reactionCount,
            syncState,
            type,
            data,
            metadata,
            mentionees
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper
            .add("uniqueId", uniqueId)
            .add("messageId", messageId)
            .add("subChannelId", subChannelId)
            .add("channelId", channelId)
            .add("userId", userId)
            .add("parentId", parentId)
            .add("segment", channelSegment)
            .add("childrenNumber", childrenNumber)
            .add("editedAt", editedAt)
            .add("isDeleted", isDeleted)
            .add("flagCount", flagCount)
            .add("tags", tags)
            .add("reactions", reactions)
            .add("reactionCount", reactionCount)
            .add("syncState", syncState)
            .add("type", type)
            .add("data", data)
            .add("metadata", metadata)
            .add("mentionees", mentionees)
        return super.internalToString(toStringHelper)
    }

}