package com.amity.socialcloud.sdk.api.social.post.create.datatype

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.google.gson.JsonObject

class AmityTextPostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreator(targetType, targetId, metadata, mentionees) {

    class Builder internal constructor() {
        private var targetType: String = ""
        private var targetId: String = ""
        private var text: String = ""
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        /**
         * @param [text] to add text to the post
         * @return the same instance of AmityTextPostCreator.Builder
         */
        fun text(text: String): Builder {
            this.text = text
            return this
        }

        /**
         * @param [metadata] to add metadata to the post
         * @return the same instance of AmityTextPostCreator.Builder
         */
        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        /**
         * @param [userIds] list of userId of users to be mentioned by this post
         * @return the same instance of AmityTextPostCreator.Builder
         */
        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        /**
         * Instantiates AmityTextPostCreator with built params.
         * @return new instance of AmityTextPostCreator.
         */
        fun build(): AmityTextPostCreator {
            return AmityTextPostCreator(targetType, targetId, text, metadata, mentionees)
        }
    }

    override fun getText(): String {
        return text
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.TEXT
    }


}
