package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MessagePreviewEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto

internal class SubChannelUpdated : SubChannelEventListener() {

    override fun getEventName(): String {
        return "message-feed.updated"
    }
    
    override fun processEvent(dto: SubChannelListDto) {
        super.processEvent(dto)
        dto.subChannels.map { subChannel ->
            MessagePreviewEvent.SubChannelUpdated(subChannel).let(MessagePreviewEventBus::publish)
        }
    }
}