package com.amity.socialcloud.sdk.chat.data.marker.readreceipt

import com.ekoapp.ekosdk.internal.SubChannelReadReceiptEntity
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity
import io.reactivex.rxjava3.core.Completable

internal class ReadReceiptRepository {

    fun getLegacyReadReceipt(subChannelId: String): SubChannelReadReceiptEntity? {
        return ReadReceiptLocalDataStore().getLegacyReadReceipt(subChannelId)
    }

    fun saveLegacyReadReceipts(
            readReceipts: List<SubChannelReadReceiptEntity>,
    ): Completable {
        return ReadReceiptLocalDataStore().saveLegacyReadReceipts(readReceipts)
    }

    fun updateLegacyLatestSegment(subChannelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLegacyLatestSegment(subChannelId, segment)
    }

    fun updateLegacyLatestSyncSegment(subChannelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLegacyLatestSyncSegment(subChannelId, segment)
    }

    fun deleteLegacyReadReceipt(subChannelId: String) {
        ReadReceiptLocalDataStore().deleteLegacyReadReceipt(subChannelId)
    }

    fun getUnsyncLegacyReadReceipt(): List<SubChannelReadReceiptEntity> {
        return ReadReceiptLocalDataStore().getUnsyncLegacyReadReceipt()
    }

    fun getReadReceipt(channelId: String): ChannelReadReceiptEntity? {
        return ReadReceiptLocalDataStore().getReadReceipt(channelId)
    }

    fun saveReadReceipts(
            readReceipts: List<ChannelReadReceiptEntity>,
    ): Completable {
        return ReadReceiptLocalDataStore().saveReadReceipts(readReceipts)
    }

    fun updateLatestSegment(channelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLatestSegment(channelId, segment)
    }

    fun updateLatestSyncSegment(channelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLatestSyncSegment(channelId, segment)
    }

    fun deleteReadReceipt(channelId: String) {
        ReadReceiptLocalDataStore().deleteLegacyReadReceipt(channelId)
    }

    fun getUnsyncReadReceipt(): List<ChannelReadReceiptEntity> {
        return ReadReceiptLocalDataStore().getUnsyncReadReceipt()
    }

}