package com.amity.socialcloud.sdk.social.domain.community.member

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMember

internal class CommunityMemberComposerUseCase : ComposerUseCase() {

    fun execute(member: AmityCommunityMember): AmityCommunityMember {
        UserGetUseCase().execute(member.getUserId())?.let {
            member.user = it
        }
        return member
    }
}