package com.amity.socialcloud.sdk.api.chat.subchannel

import com.amity.socialcloud.sdk.api.chat.AmityChatClient
import com.amity.socialcloud.sdk.api.chat.subchannel.query.AmitySubChannelQuery
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.chat.domain.marker.reader.SubscribeToSubChannelMarkerTopicUseCase
import com.amity.socialcloud.sdk.chat.domain.marker.reader.UnsubscribeToSubChannelMarkerTopicUseCase
import com.amity.socialcloud.sdk.chat.domain.subchannel.SubChannelCreateUseCase
import com.amity.socialcloud.sdk.chat.domain.subchannel.SubChannelDeleteUseCase
import com.amity.socialcloud.sdk.chat.domain.subchannel.SubChannelLiveObjectUseCase
import com.amity.socialcloud.sdk.chat.domain.subchannel.SubChannelUpdateUseCase
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

class AmitySubChannelRepository internal constructor() {
    
    /* begin_public_function
	  id: subchannel.get
	*/
    fun getSubChannel(subChannelId: String): Flowable<AmitySubChannel> {
        return SubChannelLiveObjectUseCase().execute(subChannelId)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: subchannel.query
      api_style: live_collection
	*/
    fun getSubChannels(): AmitySubChannelQuery.Builder {
        return AmitySubChannelQuery.Builder()
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: subchannel.create
	*/
    fun createSubChannel(channelId: String, displayName: String): Single<AmitySubChannel> {
        return SubChannelCreateUseCase().execute(channelId, displayName)
    }
    /* end_public_function */

    /* begin_public_function
    id: subchannel.update
    */
    fun editSubChannel(subChannelId: String, displayName: String): Completable {
        return SubChannelUpdateUseCase().execute(subChannelId, displayName)
    }
    /* end_public_function */

    /* begin_public_function
   id: subchannel.soft_delete
   */
    fun softDeleteSubChannel(subChannelId: String): Completable {
        return SubChannelDeleteUseCase().execute(subChannelId, false)
    }
    /* end_public_function */

    /* begin_public_function
    id: subchannel.hard_delete
    */
    fun hardDeleteSubChannel(subChannelId: String): Completable {
        return SubChannelDeleteUseCase().execute(subChannelId, true)
    }
    /* end_public_function */

    /* begin_public_function
     id: channel.start_reading
   */
    fun startMessageReceiptSync(subChannelId: String): Completable {
        return 	SubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId)
    }
    /* end_public_function */

    /* begin_public_function
	  id: channel.stop_reading
	*/
    fun stopMessageReceiptSync(subChannelId: String): Completable {
        return 	UnsubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId)
    }
    /* end_public_function */
}