package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.SubChannelReadReceiptEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class SubChannelReadReceiptDao : EkoObjectDao<SubChannelReadReceiptEntity>() {
	@Query("SELECT * from read_receipt where subChannelId = :subChannelId LIMIT 1")
	abstract fun getById(subChannelId: String): Flowable<SubChannelReadReceiptEntity>

	@Query("SELECT * from read_receipt where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): SubChannelReadReceiptEntity?

	@Query("DELETE from read_receipt")
	abstract override fun deleteAll()

	@Query("DELETE from read_receipt where subChannelId = :subChannelId")
	abstract fun deleteBySubChannelId(subChannelId: String)

	@Query("UPDATE read_receipt set latestSegment = :segment where subChannelId = :subChannelId and latestSegment < :segment")
	abstract fun updateLatestSegment(subChannelId: String, segment: Int)

	@Query("UPDATE read_receipt set latestSyncSegment = :segment where subChannelId = :subChannelId and latestSyncSegment < :segment")
	abstract fun updateLatestSyncSegment(subChannelId: String, segment: Int)

	@Query("SELECT * from read_receipt where latestSyncSegment < latestSegment")
	abstract fun getUnsyncReadReceipts(): List<SubChannelReadReceiptEntity>
}