/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk;

import androidx.annotation.NonNull;
import com.google.common.base.Objects;

public enum EkoChannelReadStatus {
    READING("reading"),
    NOT_READING("not_reading"),
    UNKNOWN("unknown");

    @NonNull
    private final String apiKey;

    private EkoChannelReadStatus(String apiKey) {
        this.apiKey = apiKey;
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    public static EkoChannelReadStatus fromApiKey(@NonNull String apiKey) {
        if (Objects.equal((Object)EkoChannelReadStatus.READING.apiKey, (Object)apiKey)) {
            return READING;
        }
        if (Objects.equal((Object)EkoChannelReadStatus.NOT_READING.apiKey, (Object)apiKey)) {
            return NOT_READING;
        }
        return UNKNOWN;
    }
}

