package com.amity.socialcloud.sdk.social.domain.post

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.FileGetUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.domain.comment.LatestCommentsGetUseCase
import com.amity.socialcloud.sdk.social.domain.community.CommunityGetUseCase
import com.amity.socialcloud.sdk.social.domain.community.member.CommunityMemberGetUseCase
import com.amity.socialcloud.sdk.social.domain.post.flag.IsPostFlaggedByMeUseCase

internal class PinnedPostComposerUseCase : ComposerUseCase() {

    fun execute(pin: AmityPinnedPost): AmityPinnedPost {
        addPost(pin)
        addPinnedUser(pin)
        return pin
    }
    
    private fun addPost(pin: AmityPinnedPost) {
        pin.post = PostGetUseCase().execute(pin.postId)
    }
    private fun addPinnedUser(pin: AmityPinnedPost) {
        pin.pinnedBy = UserGetUseCase().execute(pin.pinnedById)
    }
}