package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class ChannelLiveObjectUseCase : LiveObjectUseCase<EkoChannelEntity, AmityChannel>() {

    override fun createRepository(): AmityObjectRepository<EkoChannelEntity, AmityChannel> =
        ChannelRepository()

    override fun composeModel(model: AmityChannel): AmityChannel = ChannelComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.CHANNEL

}