package com.amity.socialcloud.sdk.chat.data.message.paging

import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

internal class MessageKeyCreator(
    private val subChannelId: String,
    private val isFilterByParentId: Boolean,
    private val parentId: String?,
    private val includingTags: AmityTags,
    private val excludingTags: AmityTags,
    private val isDeleted: Boolean?,
    private val sortOption: AmityMessageQuerySortOption,
    private val dataType: String?,
    private val aroundMessageId: String?,
    private val uniqueId: String? = null
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "subChannelId" to subChannelId,
            "parentId" to (parentId ?: "null"),
            "isFilterByParentId" to isFilterByParentId,
            "includingTags" to includingTags.get().toString(),
            "excludingTags" to excludingTags.get().toString(),
            "isDeleted" to (isDeleted?.toString() ?: "null"),
            "sortOption" to sortOption.apiKey,
            "dataType" to (dataType ?: ""),
            "aroundMessageId" to (aroundMessageId ?: "null"),
            "uniqueId" to (uniqueId ?: "null")
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            subChannelId = subChannelId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            type = dataType
        )
    }

    private fun getConditionStatement(
        subChannelId: String,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
        type: String?
    ): String {
        //channel filter
        val channelFilterStatement =
            "message.subChannelId = '$subChannelId'"

        //including tags filter
        val includingTagsFilterStatement = if (includingTags.isEmpty()) "" else
            " and message.uniqueId IN (SELECT messageId from message_tag where tagName IN (${includingTags.toSqlArray()}))"

        //excluding tags filter
        val excludingTagsFilterStatement = if (excludingTags.isEmpty()) "" else
            " and message.uniqueId not IN (SELECT messageId from message_tag where tagName IN (${excludingTags.toSqlArray()}))"

        //isDeleted filter
        val isDeletedFilterStatement = when (isDeleted) {
            null -> {
                ""
            }
            true -> {
                " and message.isDeleted = 1"
            }
            false -> {
                " and message.isDeleted = 0"
            }
        }
    
        //Type filter
        val typeFilterStatement = if (type == null || type.isEmpty()) "" else
            " and message.type == '$type'"

        return channelFilterStatement +
                includingTagsFilterStatement +
                excludingTagsFilterStatement +
                isDeletedFilterStatement +
                typeFilterStatement
    }

}