package com.amity.socialcloud.sdk.chat.data.message

import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateMessageRequest
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface MessageApi {

    @GET("api/v5/messages/{messageId}")
    fun getMessage(
        @Path("messageId") messageId: String,
    ): Single<MessageQueryDto>

    @POST("api/v5/messages")
    fun createMessage(
        @Body request: CreateMessageRequest
    ): Single<MessageQueryDto>

    @PUT("api/v5/messages/{messageId}")
    fun updateMessage(
        @Path("messageId") messageId: String,
        @Body request: MessageUpdateDataRequest
    ): Single<MessageQueryDto>

    @DELETE("api/v5/messages/{messageId}")
    fun deleteMessage(
        @Path("messageId") messageId: String
    ): Single<MessageQueryDto>

    @GET("api/v5/messages")
    fun queryMessages(
        @Query("messageFeedId") subChannelId: String? = null,
        @Query("filterByParentId") filterByParentId: Boolean? = null,
        @Query("parentId") parentId: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("includeTags[]") tags: List<String>? = null,
        @Query("excludeTags[]") excludeTags: List<String>? = null,
        @Query("dataType", encoded = true) dataType: String? = null,
        @Query("options[around]", encoded = true) around: String? = null,
        @Query("options[skip]", encoded = true) skip: Int? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[sortBy]", encoded = true) sortBy: String? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<MessageQueryDto>

    @POST("api/v5/messages/{messageId}/flags")
    fun flagMessage(
            @Path("messageId") messageId: String,
// TODO: Uncomment when Flag message is available
//            @Body request: FlagContentRequest,
    ): Single<MessageQueryDto>

    @DELETE("api/v5/messages/{messageId}/flags")
    fun unflagMessage(
        @Path("messageId") messageId: String
    ): Single<MessageQueryDto>

    @GET("api/v5/messages/{messageId}/flags")
    fun isFlaggedByMe(
        @Path("messageId") messageId: String
    ): Single<JsonObject>

}