package com.amity.socialcloud.sdk.chat.data.channel

import com.ekoapp.ekosdk.internal.api.dto.ChannelQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelsReadRequest
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CreateChannelRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CreateConversationWithUserIdsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface ChannelApi {

    @POST("api/v3/channels")
    fun createChannel(@Body request: CreateChannelRequest): Single<ChannelQueryDto>

    @POST("api/v3/channels/conversation")
    fun createConversationChannel(@Body request: CreateConversationWithUserIdsRequest): Single<ChannelQueryDto>

    @PUT("api/v3/channels/{channelId}")
    fun updateChannel(@Path("channelId") channelId: String, @Body request: ChannelUpdateRequest): Single<ChannelQueryDto>

    @GET("api/v3/channels/{channelId}")
    fun getChannel(@Path("channelId") channelId: String): Single<ChannelQueryDto>

    @POST("api/v3/channels/{channelId}/join")
    fun joinChannel(@Path("channelId") channelId: String): Single<ChannelQueryDto>

    @DELETE("api/v3/channels/{channelId}/leave")
    fun leaveChannel(@Path("channelId") channelId: String): Single<ChannelQueryDto>

    @GET("api/v3/channels")
    fun queryChannels(
        @Query("tags[]") tags: List<String>? = null,
        @Query("excludeTags[]") excludeTags: List<String>? = null,
        @Query("types[]") types: List<String>? = null,
        @Query("filter") filter: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<ChannelQueryDto>

    @GET("api/v3/channels/list")
    fun getChannels(
        @Query("channelIds[]") channelIds: List<String>
    ): Single<ChannelQueryDto>

    @POST("api/v3/channels/seen")
    fun bulkMarkSeen(
        @Body channels: ChannelsReadRequest
    ): Single<JsonObject>
}