package com.amity.socialcloud.sdk.api.chat.channel.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.chat.domain.channel.GetChannelPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

abstract class AmityChannelQuery internal constructor(private val isDeleted: Boolean?,
                                                      private val types: Set<AmityChannel.Type>,
                                                      private val filter: AmityChannelFilter,
                                                      private val includingTags: AmityTags,
                                                      private val excludingTags: AmityTags
) {

    fun query(): Flowable<PagingData<AmityChannel>> {
        return GetChannelPagingDataUseCase().execute(isDeleted, types, filter, includingTags, excludingTags)
    }
}