package com.amity.socialcloud.sdk.model.social.category

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityCommunityCategory internal constructor(
    private val categoryId: String,
    private val name: String,
    internal var avatarFileId: String?,
    internal var avatar: AmityImage?,
    private val metadata: JsonObject?,
    private val isDeleted: Boolean,
    private val createdAt: DateTime,
    private val updatedAt: DateTime
) : Parcelable, ReactorObject {

    fun getCategoryId(): String {
        return categoryId
    }

    fun getName(): String {
        return name
    }

    fun getAvatar(): AmityImage? {
        return avatar
    }

    fun getMetadata(): JsonObject? {
        return metadata
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return categoryId
    }
}