package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoFeedDto
import com.ekoapp.ekosdk.internal.entity.FeedEntity

interface EkoFeedMapper : EkoObjectMapper<EkoFeedDto, FeedEntity> {
	companion object {
		val MAPPER: EkoFeedMapper = object: EkoFeedMapper {
			override fun map(dto: EkoFeedDto): FeedEntity {
				val feed = FeedEntity()
				feed.feedId = dto.feedId!!
				feed.feedType = dto.feedType
				feed.targetId = dto.targetId
				feed.targetType = dto.targetType
				feed.postCount = dto.postCount!!
				feed.createdAt = dto.createdAt
				feed.updatedAt = dto.updatedAt
				return feed
			}
		}
	}
}