package com.ekoapp.ekosdk.internal.api.dto

import com.ekoapp.ekosdk.internal.data.model.EkoChannelQueryToken
import com.google.gson.annotations.SerializedName

data class ChannelQueryDto (
	@SerializedName("channels")
	val channelDtoList: List<EkoChannelDto> = emptyList(),
	
	@SerializedName("channelUsers")
	val channelMembershipDtoList: List<EkoChannelMembershipDto> = emptyList(),
	
	@SerializedName("paging")
	val token: EkoChannelQueryToken = EkoChannelQueryToken(),
	
	@SerializedName("users")
	val users: List<EkoUserDto> = emptyList(),
	
	@SerializedName("files")
	val files: List<EkoFileDto> = emptyList(),
	
	@SerializedName("messagePreviews")
	val messagePreviews: List<MessagePreviewDto> = emptyList(),
	
	@SerializedName("messageFeedsInfo")
	val subChannelInfos: List<SubChannelInfoDto> = emptyList(),
)