package com.ekoapp.ekosdk.internal.util

import android.content.Context
import com.google.common.base.Preconditions
import io.reactivex.Flowable
import io.reactivex.processors.AsyncProcessor

object AppContext {
	private val APP_CONTEXT = AsyncProcessor.create<Context>()
	@Synchronized
	fun init(context: Context) {
		Preconditions.checkNotNull(context, "context is null")
		APP_CONTEXT.onNext(context.applicationContext)
		APP_CONTEXT.onComplete()
	}
	
	val flowable: Flowable<Context>
		get() = APP_CONTEXT.hide()
	
	@JvmStatic
    fun get(): Context {
		return APP_CONTEXT.value!!
	}
}