package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.annotations.SerializedName
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "user_sub_channel_marker", primaryKeys = ["subChannelId","userId"])
open class UserSubChannelMarkerEntity : EkoObject() {
    
    var subChannelId: String = ObjectId.get().toHexString()
    var channelId: String = ""
    var userId: String = ""
    var unreadCount : Int = 0
    var readToSegment: Int = 0
    var deliveredToSegment: Int = 0
    var hasMentioned: Boolean = false

    override fun getId(): String {
        return subChannelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is UserSubChannelMarkerEntity
                && Objects.equal(subChannelId, other.subChannelId)
                && Objects.equal(channelId, other.channelId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(unreadCount, other.unreadCount)
                && Objects.equal(readToSegment, other.readToSegment)
                && Objects.equal(deliveredToSegment, other.deliveredToSegment)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                && Objects.equal(hasMentioned, other.hasMentioned)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            subChannelId,
            channelId,
            userId,
            unreadCount,
            readToSegment,
            deliveredToSegment,
            createdAt,
            updatedAt,
            hasMentioned
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("subChannelId", subChannelId)
            add("channelId", channelId)
            add("userId", userId)
            add("unreadCount", unreadCount)
            add("readToSegment", readToSegment)
            add("deliveredToSegment", deliveredToSegment)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
            add("hasMentioned", hasMentioned)
        }
        return super.internalToString(toStringHelper)
    }

}