package com.amity.socialcloud.sdk.social.domain.story.delete

import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.story.StoryRepository
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import io.reactivex.rxjava3.core.Completable

internal class DeleteStoryUseCase {

    fun execute(storyId: String, permanent: Boolean): Completable {
        val cacheStory = StoryRepository().getStoryNow(storyId)
        val cacheTarget = cacheStory?.let {
            StoryTargetRepository().getStoryTarget(it.getTargetType(), it.getTargetId())
        }
        return StoryRepository().deleteStory(storyId, permanent)
                .andThen(Completable.defer {
                    if(storyId.startsWith("LOCAL_")) {
                        revertStoryTargetLocalLastExpires(cacheTarget)
                    } else {
                        revertStoryTargetLastExpires(cacheTarget)
                    }

                })
    }

    private fun revertStoryTargetLocalLastExpires(storyTarget: AmityStoryTarget?): Completable {
        if (storyTarget != null) {
            val highestStoryExpires = StoryRepository().getHighestStoryExpiresAt(
                storyTarget.getTargetType(),
                storyTarget.getTargetId()
            )
            return StoryTargetRepository().updateStoryTargetLocalLastStoryExpiresAt(
                targetType = storyTarget.getTargetType(),
                targetId = storyTarget.getTargetId(),
                localLastStoryExpiresAt = highestStoryExpires
            )
        } else {
            return Completable.complete()
        }
    }

    private fun revertStoryTargetLastExpires(storyTarget: AmityStoryTarget?): Completable {
        if (storyTarget != null) {
            val highestStoryExpires = StoryRepository().getHighestSyncedStoryExpiresAt(
                storyTarget.getTargetType(),
                storyTarget.getTargetId()
            )
            return StoryTargetRepository().updateStoryTargetLastStoryExpiresAt(
                targetType = storyTarget.getTargetType(),
                targetId = storyTarget.getTargetId(),
                lastStoryExpiresAt = highestStoryExpires
            )
        } else {
            return Completable.complete()
        }
    }

}