package com.amity.socialcloud.sdk.model.core.notificationtray

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
class AmityNotificationTrayActorIdMap : HashMap<String, DateTime?>(), Parcelable {

    val actors: Set<String>
        get() = keys

    fun getLastActedAt(actorId: String?): DateTime? {
        return if (actorId != null && containsKey(actorId)) {
            get(actorId)
        } else {
            null
        }
    }
}