package com.amity.socialcloud.sdk.core.domain.notificationtray.composer

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem

internal class NotificationTrayComposerUseCase : ComposerUseCase() {
    fun execute(notiTrayItem: AmityNotificationTrayItem): AmityNotificationTrayItem {
        addActorUser(notiTrayItem)
        return notiTrayItem
    }

    private fun addActorUser(notiTrayItem: AmityNotificationTrayItem) {
        val userList = notiTrayItem.actors.mapNotNull { UserGetUseCase().execute(it.key) }
        notiTrayItem.actorUsers = userList
    }

}