package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayItemDto
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayActorIdMap
import com.google.gson.JsonObject
import org.joda.time.DateTime

internal class NotificationTrayItemEntityMapper :
    EntityMapper<NotificationTrayItemDto, NotificationTrayItemEntity>() {
    override fun map(dto: List<NotificationTrayItemDto>): List<NotificationTrayItemEntity> {
        return dto.map { dto -> map(dto) }
    }

    private fun map(dto: NotificationTrayItemDto): NotificationTrayItemEntity {
        return NotificationTrayItemEntity().apply {
            targetId = dto.targetId ?: ""
            targetType = dto.targetType ?: ""
            actionType = dto.actionType
            actionReferenceId = dto.actionReferenceId
            actors = AmityNotificationTrayActorIdMap().apply {
                dto.actors?.forEach { actorDto ->
                    actorDto.id?.let { id ->
                        put(id, actorDto.lastActedAt)
                    }
                }
            }
            actorsCount = dto.actorsCount
            data = dto.getData() ?: JsonObject()
            notificationId = dto.id ?: ""
            daySegment = dto.daySegment ?: DateTime.now()
            lastOccurredAt = dto.lastOccurredAt
            lastSeenAt = dto.lastSeenAt
            parentId = dto.parentId
            referenceId = dto.referenceId
            referenceType = dto.referenceType
            templatedText = dto.templatedText
            text = dto.text
            trayItemCategory = dto.trayItemCategory
        }

    }
}