package com.amity.socialcloud.sdk.chat.data.marker.readuser.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.chat.data.channel.paging.MessageDeliveredUsersKeyCreator
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageDeliveredUsersPersister
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageDeliveredUsersRequest
import com.amity.socialcloud.sdk.chat.domain.marker.message.MessageDeliveredUsersComposerUseCase
import com.amity.socialcloud.sdk.core.data.user.UserListPersister
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter
import com.ekoapp.ekosdk.internal.api.dto.MessageDeliveredUsersQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

internal class MessageDeliveredUsersMediator(
    private val messageId: String,
    private val memberships: List<MessageDeliveredMembershipFilter>,
) : QueryStreamMediator<UserEntity, MessageDeliveredUsersQueryDto>(
    nonce = AmityNonce.MESSAGE_DELIVERED_USERS,
    queryStreamKeyCreator = MessageDeliveredUsersKeyCreator(
        messageId = messageId,
        memberships = memberships,
    )
) {

    override fun forceRefresh() = true

    override fun getFirstPageRequest(pageSize: Int): Single<MessageDeliveredUsersQueryDto> {
        return getRequest(limit = pageSize)

    }

    override fun getFetchByTokenRequest(token: String): Single<MessageDeliveredUsersQueryDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: MessageDeliveredUsersQueryDto): Completable {
        return MessageDeliveredUsersPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: MessageDeliveredUsersQueryDto): QueryStreamQueryToken {
        return QueryStreamQueryToken(
            queryStreamKeyCreator = queryStreamKeyCreator,
            next = dto.token?.next,
            previous = dto.token?.previous,
            primaryKeys = dto.userIds
        )
    }
    
    private fun getRequest(
        limit: Int? = null,
        token: String? = null
    ): Single<MessageDeliveredUsersQueryDto> {
        val request = MessageDeliveredUsersRequest(messageId, memberships, limit, token)
        return MessageDeliveredUsersComposerUseCase().execute(request).toRx2()
    }

}